/*
 * File: ImageProcessor.java
 * ============================================
 * A program that flips an image horizontally.
 */

import acm.program.*;
import acm.graphics.*;

public class ImageProcessor extends GraphicsProgram {
	public void run() {
		/* Get the raw image. */
		GImage source = new GImage("dark-side-of-the-moon.jpg");
		add(source);
		
		/* Flip the image and put it side-by-side. */
		GImage flipped = flipImage(source);
		flipped.setLocation(source.getWidth(), 0);
		add(flipped);
	}
	
	/**
	 * Given an image, produces a new image that's the horizontally-flipped
	 * version of the original image.
	 * 
	 * @param source The original image.
	 * @return A flipped version of it.
	 */
	private GImage flipImage(GImage source) {
		/* Get a raw pixel array from the original image. */
		int[][] pixels = source.getPixelArray();
		
		/* Compute the width and height of the image. */
		int numRows = pixels.length;
		int numCols = pixels[0].length;
		
		/* Make a new pixel array to hold the flipped image. */
		int[][] newPixels = new int[numRows][numCols];
		
		/* Copy the array over in reverse order. */
		for (int row = 0; row < numRows; row++) {
			for (int col = 0; col < numCols; col++) {
				newPixels[row][col] = pixels[row][numCols - 1 - col];
			}
		}
		
		/* Hand back the new image. */
		return new GImage(newPixels);
	}
}
